#include <iostream>
#include <vector>
#include <unordered_map>
#include <algorithm>

using namespace std;

pair<vector<long long >,long long > solve(vector<long long >& niz) {
    unordered_map<long long , long long > mapaPrefiksnihSuma; 
    unordered_map<long long , long long > mapaUcestalosti; 
    long long  maxUcestalost = 0, najucestalijiElement = niz[0];
    long long  start = -1, end = -1;
    long long  prefiksnaSuma = 0;

    mapaPrefiksnihSuma[0] = -1; 

    for (long long  i = 0; i < niz.size(); i++) {
        prefiksnaSuma += niz[i];

        if (mapaPrefiksnihSuma.find(prefiksnaSuma) != mapaPrefiksnihSuma.end()) {
            long long levo = mapaPrefiksnihSuma[prefiksnaSuma] + 1;
            vector<long long> podniz(niz.begin() + levo, niz.begin() + i + 1);

            
            unordered_map<long long, long long> tempUcestalost;
            for (long long num : podniz) tempUcestalost[num]++;

            
            for (auto& [num, ucestalost] : tempUcestalost) {
                if (ucestalost > maxUcestalost) {
                    maxUcestalost = ucestalost;
                    najucestalijiElement = num;
                    start = levo;
                    end = i;
                }
            }
        } else {
            mapaPrefiksnihSuma[prefiksnaSuma] = i;
        }
    }

    vector<long long> najboljiPodniz;
    if (start != -1) {
        najboljiPodniz.assign(niz.begin() + start, niz.begin() + end + 1);
    }

    return {najboljiPodniz, najucestalijiElement};
}

int main() {
    vector<long long> niz;
    long long n;
    cin >> n;
    for (long long i = 0; i < n; i++){
    	long long temp;
    	cin >> temp;
    	niz.push_back(temp);
    }

    auto [podniz, najucestaliji] = solve(niz);
    
    long long brojac = 0;

    for (long long num : podniz) 
    	if(num == najucestaliji) 
    		brojac++;
    cout << brojac;

    return 0;
}